<?php

namespace App\Events;

use App\Models\Domain;
use Illuminate\Broadcasting\Channel;
use Illuminate\Broadcasting\InteractsWithSockets;
use Illuminate\Broadcasting\PresenceChannel;
use Illuminate\Broadcasting\PrivateChannel;
use Illuminate\Contracts\Broadcasting\ShouldBroadcast;
use Illuminate\Foundation\Events\Dispatchable;
use Illuminate\Queue\SerializesModels;

class DomainVerified implements ShouldBroadcast
{
    use Dispatchable, InteractsWithSockets, SerializesModels;

    public $domain;
    public $verificationMethod;
    public $verifiedAt;

    /**
     * Create a new event instance.
     */
    public function __construct(Domain $domain, string $verificationMethod)
    {
        $this->domain = $domain;
        $this->verificationMethod = $verificationMethod;
        $this->verifiedAt = now();
    }

    /**
     * Get the channels the event should broadcast on.
     *
     * @return array<int, \Illuminate\Broadcasting\Channel>
     */
    public function broadcastOn(): array
    {
        return [
            new PrivateChannel('user.' . $this->domain->user_id),
            new PrivateChannel('domain.' . $this->domain->id)
        ];
    }
    
    /**
     * The event's broadcast name.
     */
    public function broadcastAs(): string
    {
        return 'domain.verified';
    }
    
    /**
     * Get the data to broadcast.
     */
    public function broadcastWith(): array
    {
        return [
            'domain_id' => $this->domain->id,
            'domain' => $this->domain->domain,
            'verification_method' => $this->verificationMethod,
            'verified_at' => $this->verifiedAt->toISOString(),
            'message' => "Domain {$this->domain->domain} has been successfully verified!",
            'status' => 'verified'
        ];
    }
}