<?php

return [

    /*
    |--------------------------------------------------------------------------
    | Feature Flags
    |--------------------------------------------------------------------------
    */

    'features' => [
        'trials' => env('SUBSCRIPTION_TRIALS_ENABLED', true),
        'coupons' => env('SUBSCRIPTION_COUPONS_ENABLED', true),
        'metered_billing' => env('SUBSCRIPTION_METERED_BILLING', false),
        'dunning_management' => env('SUBSCRIPTION_DUNNING_ENABLED', true),
        'proration' => env('SUBSCRIPTION_PRORATION_ENABLED', true),
        'invoice_generation' => env('SUBSCRIPTION_INVOICES_ENABLED', true),
    ],

    /*
    |--------------------------------------------------------------------------
    | General Settings
    |--------------------------------------------------------------------------
    */

    'enabled' => env('SUBSCRIPTIONS_ENABLED', true),
    'currency' => env('SUBSCRIPTION_CURRENCY', 'USD'),
    'tax_rate' => env('SUBSCRIPTION_TAX_RATE', 0.0), // 0.0 = 0%, 0.1 = 10%
    'trial_period_days' => env('SUBSCRIPTION_TRIAL_DAYS', 14),
    'grace_period_days' => env('SUBSCRIPTION_GRACE_DAYS', 3),

    /*
    |--------------------------------------------------------------------------
    | Payment Providers
    |--------------------------------------------------------------------------
    */

    'providers' => [
        'default' => env('PAYMENT_PROVIDER', 'stripe'),

        'stripe' => [
            'enabled' => env('STRIPE_ENABLED', true),
            'key' => env('STRIPE_KEY'),
            'secret' => env('STRIPE_SECRET'),
            'webhook_secret' => env('STRIPE_WEBHOOK_SECRET'),
            'webhook_tolerance' => env('STRIPE_WEBHOOK_TOLERANCE', 300),
            'model' => 'App\Models\User',
            'currency' => env('STRIPE_CURRENCY', 'usd'),
        ],

        'paypal' => [
            'enabled' => env('PAYPAL_ENABLED', false),
            'client_id' => env('PAYPAL_CLIENT_ID'),
            'client_secret' => env('PAYPAL_CLIENT_SECRET'),
            'webhook_id' => env('PAYPAL_WEBHOOK_ID'),
            'sandbox' => env('PAYPAL_SANDBOX', true),
            'currency' => env('PAYPAL_CURRENCY', 'USD'),
        ],

        'paddle' => [
            'enabled' => env('PADDLE_ENABLED', false),
            'vendor_id' => env('PADDLE_VENDOR_ID'),
            'vendor_auth_code' => env('PADDLE_VENDOR_AUTH_CODE'),
            'public_key' => env('PADDLE_PUBLIC_KEY'),
            'sandbox' => env('PADDLE_SANDBOX', true),
        ],
    ],

    /*
    |--------------------------------------------------------------------------
    | Subscription Plans
    |--------------------------------------------------------------------------
    */

    'plans' => [
        'free' => [
            'name' => 'Free Plan',
            'description' => 'Basic trust seal features',
            'price' => 0,
            'billing_cycle' => null,
            'stripe_price_id' => null,
            'features' => [
                'max_domains' => 1,
                'max_trust_seals' => 1,
                'basic_analytics' => true,
                'email_support' => true,
                'ssl_monitoring' => true,
                'security_checks' => 'basic',
                'custom_branding' => false,
                'api_access' => false,
                'priority_support' => false,
                'advanced_analytics' => false,
                'white_label' => false,
            ],
            'limits' => [
                'domains' => 1,
                'trust_seals_per_domain' => 1,
                'api_requests_per_month' => 0,
                'analytics_retention_days' => 30,
                'security_checks_per_day' => 1,
            ],
        ],

        'basic' => [
            'name' => 'Basic Plan',
            'description' => 'Enhanced features for small businesses',
            'price' => 9.99,
            'billing_cycle' => 'monthly',
            'stripe_price_id' => env('STRIPE_BASIC_MONTHLY_PRICE_ID'),
            'yearly_price' => 99.99,
            'yearly_stripe_price_id' => env('STRIPE_BASIC_YEARLY_PRICE_ID'),
            'trial_period_days' => 14,
            'features' => [
                'max_domains' => 5,
                'max_trust_seals' => 15,
                'basic_analytics' => true,
                'email_support' => true,
                'ssl_monitoring' => true,
                'security_checks' => 'standard',
                'custom_branding' => true,
                'api_access' => 'basic',
                'priority_support' => false,
                'advanced_analytics' => false,
                'white_label' => false,
            ],
            'limits' => [
                'domains' => 5,
                'trust_seals_per_domain' => 3,
                'api_requests_per_month' => 10000,
                'analytics_retention_days' => 90,
                'security_checks_per_day' => 5,
            ],
        ],

        'premium' => [
            'name' => 'Premium Plan',
            'description' => 'Advanced features for growing businesses',
            'price' => 29.99,
            'billing_cycle' => 'monthly',
            'stripe_price_id' => env('STRIPE_PREMIUM_MONTHLY_PRICE_ID'),
            'yearly_price' => 299.99,
            'yearly_stripe_price_id' => env('STRIPE_PREMIUM_YEARLY_PRICE_ID'),
            'trial_period_days' => 14,
            'popular' => true,
            'features' => [
                'max_domains' => 25,
                'max_trust_seals' => 75,
                'basic_analytics' => true,
                'advanced_analytics' => true,
                'email_support' => true,
                'priority_support' => true,
                'ssl_monitoring' => true,
                'security_checks' => 'advanced',
                'custom_branding' => true,
                'api_access' => 'full',
                'white_label' => false,
            ],
            'limits' => [
                'domains' => 25,
                'trust_seals_per_domain' => 10,
                'api_requests_per_month' => 100000,
                'analytics_retention_days' => 365,
                'security_checks_per_day' => 25,
            ],
        ],

        'enterprise' => [
            'name' => 'Enterprise Plan',
            'description' => 'Full-featured solution for large organizations',
            'price' => 99.99,
            'billing_cycle' => 'monthly',
            'stripe_price_id' => env('STRIPE_ENTERPRISE_MONTHLY_PRICE_ID'),
            'yearly_price' => 999.99,
            'yearly_stripe_price_id' => env('STRIPE_ENTERPRISE_YEARLY_PRICE_ID'),
            'trial_period_days' => 30,
            'contact_sales' => true,
            'features' => [
                'max_domains' => -1, // unlimited
                'max_trust_seals' => -1, // unlimited
                'basic_analytics' => true,
                'advanced_analytics' => true,
                'email_support' => true,
                'priority_support' => true,
                'phone_support' => true,
                'ssl_monitoring' => true,
                'security_checks' => 'enterprise',
                'custom_branding' => true,
                'api_access' => 'unlimited',
                'white_label' => true,
                'dedicated_account_manager' => true,
                'sla_guarantee' => true,
            ],
            'limits' => [
                'domains' => -1, // unlimited
                'trust_seals_per_domain' => -1, // unlimited
                'api_requests_per_month' => -1, // unlimited
                'analytics_retention_days' => -1, // unlimited
                'security_checks_per_day' => -1, // unlimited
            ],
        ],
    ],

    /*
    |--------------------------------------------------------------------------
    | Billing Cycles
    |--------------------------------------------------------------------------
    */

    'billing_cycles' => [
        'monthly' => [
            'name' => 'Monthly',
            'interval' => 'month',
            'interval_count' => 1,
            'discount' => 0,
        ],
        'yearly' => [
            'name' => 'Yearly',
            'interval' => 'year',
            'interval_count' => 1,
            'discount' => 20, // 20% discount
        ],
        'lifetime' => [
            'name' => 'Lifetime',
            'interval' => null,
            'interval_count' => null,
            'discount' => 0,
            'multiplier' => 25, // 25x monthly price
        ],
    ],

    /*
    |--------------------------------------------------------------------------
    | Coupons and Discounts
    |--------------------------------------------------------------------------
    */

    'coupons' => [
        'enabled' => env('COUPONS_ENABLED', true),
        'types' => [
            'percentage' => 'Percentage Discount',
            'fixed' => 'Fixed Amount Discount',
            'free_trial' => 'Extended Free Trial',
        ],
        'default_duration' => 'once', // once, repeating, forever
        'max_redemptions' => null, // null = unlimited
    ],

    /*
    |--------------------------------------------------------------------------
    | Notifications
    |--------------------------------------------------------------------------
    */

    'notifications' => [
        'payment_succeeded' => [
            'enabled' => true,
            'channels' => ['mail', 'database'],
        ],
        'payment_failed' => [
            'enabled' => true,
            'channels' => ['mail', 'database'],
            'retry_attempts' => 3,
        ],
        'subscription_created' => [
            'enabled' => true,
            'channels' => ['mail', 'database'],
        ],
        'subscription_updated' => [
            'enabled' => true,
            'channels' => ['database'],
        ],
        'subscription_cancelled' => [
            'enabled' => true,
            'channels' => ['mail', 'database'],
        ],
        'subscription_renewed' => [
            'enabled' => true,
            'channels' => ['mail', 'database'],
        ],
        'trial_ending' => [
            'enabled' => true,
            'channels' => ['mail', 'database'],
            'days_before' => [7, 3, 1],
        ],
        'subscription_expiring' => [
            'enabled' => true,
            'channels' => ['mail', 'database'],
            'days_before' => [7, 3, 1],
        ],
    ],

    /*
    |--------------------------------------------------------------------------
    | Usage Tracking
    |--------------------------------------------------------------------------
    */

    'usage_tracking' => [
        'enabled' => env('USAGE_TRACKING_ENABLED', true),
        'metrics' => [
            'domains_count' => [
                'name' => 'Active Domains',
                'description' => 'Number of verified domains',
                'billable' => false,
            ],
            'trust_seals_count' => [
                'name' => 'Trust Seals',
                'description' => 'Number of active trust seals',
                'billable' => false,
            ],
            'api_requests' => [
                'name' => 'API Requests',
                'description' => 'Monthly API request count',
                'billable' => true,
                'overage_rate' => 0.001, // $0.001 per request over limit
            ],
            'security_checks' => [
                'name' => 'Security Checks',
                'description' => 'Daily security check count',
                'billable' => false,
            ],
        ],
        'reporting_interval' => 'monthly',
        'reset_cycle' => 'billing_cycle', // billing_cycle, calendar_month
    ],

    /*
    |--------------------------------------------------------------------------
    | Webhooks
    |--------------------------------------------------------------------------
    */

    'webhooks' => [
        'stripe' => [
            'events' => [
                'customer.subscription.created',
                'customer.subscription.updated',
                'customer.subscription.deleted',
                'invoice.payment_succeeded',
                'invoice.payment_failed',
                'customer.subscription.trial_will_end',
            ],
            'verify_signature' => true,
            'tolerance' => 300, // seconds
        ],
        'paypal' => [
            'events' => [
                'BILLING.SUBSCRIPTION.CREATED',
                'BILLING.SUBSCRIPTION.UPDATED',
                'BILLING.SUBSCRIPTION.CANCELLED',
                'PAYMENT.SALE.COMPLETED',
                'PAYMENT.SALE.DENIED',
            ],
            'verify_signature' => true,
        ],
    ],

    /*
    |--------------------------------------------------------------------------
    | Invoice Settings
    |--------------------------------------------------------------------------
    */

    'invoices' => [
        'enabled' => true,
        'company' => [
            'name' => env('INVOICE_COMPANY_NAME', 'Trust Seal Portal'),
            'address' => env('INVOICE_COMPANY_ADDRESS'),
            'city' => env('INVOICE_COMPANY_CITY'),
            'state' => env('INVOICE_COMPANY_STATE'),
            'zip' => env('INVOICE_COMPANY_ZIP'),
            'country' => env('INVOICE_COMPANY_COUNTRY'),
            'tax_id' => env('INVOICE_COMPANY_TAX_ID'),
        ],
        'prefix' => env('INVOICE_PREFIX', 'TSP-'),
        'number_sequence' => 'yearly', // yearly, monthly, continuous
        'due_days' => 30,
        'late_fee' => [
            'enabled' => false,
            'percentage' => 5,
            'grace_period_days' => 7,
        ],
        'auto_send' => true,
        'reminder_schedule' => [7, 3, 1], // days before due date
    ],

    /*
    |--------------------------------------------------------------------------
    | Proration Settings
    |--------------------------------------------------------------------------
    */

    'proration' => [
        'enabled' => true,
        'upgrade_immediately' => true,
        'downgrade_at_period_end' => true,
        'credit_unused_time' => true,
    ],

    /*
    |--------------------------------------------------------------------------
    | Feature Flags
    |--------------------------------------------------------------------------
    */

    'features' => [
        'trials' => env('SUBSCRIPTION_TRIALS_ENABLED', true),
        'coupons' => env('SUBSCRIPTION_COUPONS_ENABLED', true),
        'metered_billing' => env('SUBSCRIPTION_METERED_BILLING', false),
        'dunning_management' => env('SUBSCRIPTION_DUNNING_ENABLED', true),
        'proration' => env('SUBSCRIPTION_PRORATION_ENABLED', true),
        'invoice_generation' => env('SUBSCRIPTION_INVOICES_ENABLED', true),
    ],

];