<?php

return [

    /*
    |--------------------------------------------------------------------------
    | Trust Seal Configuration
    |--------------------------------------------------------------------------
    |
    | This file contains configuration options for the trust seal system,
    | including display settings, security options, and validation rules.
    |
    */

    /*
    |--------------------------------------------------------------------------
    | Default Settings
    |--------------------------------------------------------------------------
    */

    'defaults' => [
        'enabled' => true,
        'display_type' => 'badge', // badge, banner, widget
        'position' => 'bottom-right', // bottom-right, bottom-left, top-right, top-left
        'size' => 'medium', // small, medium, large
        'theme' => 'light', // light, dark, auto
        'show_company_name' => true,
        'show_verification_date' => true,
        'show_ssl_status' => true,
        'show_security_score' => false,
        'animation' => 'fade', // none, fade, slide, bounce
        'auto_hide' => false,
        'auto_hide_delay' => 5000, // milliseconds
    ],

    /*
    |--------------------------------------------------------------------------
    | Display Options
    |--------------------------------------------------------------------------
    */

    'display' => [
        'types' => [
            'badge' => [
                'name' => 'Security Badge',
                'description' => 'Small circular or rectangular badge',
                'sizes' => ['small' => '60px', 'medium' => '80px', 'large' => '100px'],
                'premium_only' => false,
            ],
            'banner' => [
                'name' => 'Security Banner',
                'description' => 'Horizontal banner across page',
                'sizes' => ['small' => '300px', 'medium' => '400px', 'large' => '500px'],
                'premium_only' => false,
            ],
            'widget' => [
                'name' => 'Security Widget',
                'description' => 'Detailed security information widget',
                'sizes' => ['small' => '200px', 'medium' => '300px', 'large' => '400px'],
                'premium_only' => true,
            ],
            'floating' => [
                'name' => 'Floating Seal',
                'description' => 'Floating seal that follows scroll',
                'sizes' => ['small' => '50px', 'medium' => '70px', 'large' => '90px'],
                'premium_only' => true,
            ],
            'modal' => [
                'name' => 'Security Modal',
                'description' => 'Click-to-open detailed security modal',
                'sizes' => ['small' => '400px', 'medium' => '600px', 'large' => '800px'],
                'premium_only' => true,
            ],
        ],

        'positions' => [
            'top-left' => 'Top Left',
            'top-right' => 'Top Right',
            'bottom-left' => 'Bottom Left',
            'bottom-right' => 'Bottom Right',
            'center' => 'Center',
            'custom' => 'Custom Position',
        ],

        'themes' => [
            'light' => [
                'name' => 'Light Theme',
                'colors' => [
                    'primary' => '#ffffff',
                    'secondary' => '#f8f9fa',
                    'text' => '#212529',
                    'border' => '#dee2e6',
                    'success' => '#28a745',
                    'warning' => '#ffc107',
                    'danger' => '#dc3545',
                ],
            ],
            'dark' => [
                'name' => 'Dark Theme',
                'colors' => [
                    'primary' => '#212529',
                    'secondary' => '#343a40',
                    'text' => '#ffffff',
                    'border' => '#495057',
                    'success' => '#28a745',
                    'warning' => '#ffc107',
                    'danger' => '#dc3545',
                ],
            ],
            'brand' => [
                'name' => 'Brand Colors',
                'colors' => [
                    'primary' => '#007bff',
                    'secondary' => '#6c757d',
                    'text' => '#212529',
                    'border' => '#007bff',
                    'success' => '#28a745',
                    'warning' => '#ffc107',
                    'danger' => '#dc3545',
                ],
                'premium_only' => true,
            ],
        ],

        'animations' => [
            'none' => 'No Animation',
            'fade' => 'Fade In/Out',
            'slide' => 'Slide In/Out',
            'bounce' => 'Bounce Effect',
            'pulse' => 'Pulse Effect',
            'shake' => 'Shake Effect',
        ],
    ],

    /*
    |--------------------------------------------------------------------------
    | Security Features
    |--------------------------------------------------------------------------
    */

    'security' => [
        'verification_methods' => [
            'dns' => [
                'name' => 'DNS Verification',
                'description' => 'Verify domain ownership via DNS TXT record',
                'enabled' => true,
                'ttl' => 3600, // seconds
            ],
            'file' => [
                'name' => 'File Upload Verification',
                'description' => 'Verify domain ownership via file upload',
                'enabled' => true,
                'filename_prefix' => 'trustseal-verification-',
                'valid_extensions' => ['txt', 'html'],
            ],
            'meta' => [
                'name' => 'Meta Tag Verification',
                'description' => 'Verify domain ownership via HTML meta tag',
                'enabled' => true,
                'tag_name' => 'trustseal-verification',
            ],
        ],

        'ssl_checks' => [
            'enabled' => true,
            'check_chain' => true,
            'check_expiry' => true,
            'warning_days' => 30, // Days before expiry to show warning
            'critical_days' => 7, // Days before expiry to show critical alert
        ],

        'malware_scanning' => [
            'enabled' => true,
            'providers' => [
                'google_safe_browsing' => [
                    'enabled' => env('GOOGLE_SAFE_BROWSING_ENABLED', true),
                    'api_key' => env('GOOGLE_SAFE_BROWSING_API_KEY'),
                ],
                'virustotal' => [
                    'enabled' => env('VIRUSTOTAL_ENABLED', false),
                    'api_key' => env('VIRUSTOTAL_API_KEY'),
                ],
            ],
            'scan_frequency' => 'daily', // hourly, daily, weekly
            'quarantine_on_detection' => true,
        ],

        'blacklist_checks' => [
            'enabled' => true,
            'providers' => [
                'spamhaus',
                'surbl',
                'uribl',
            ],
            'check_frequency' => 'daily',
        ],
    ],

    /*
    |--------------------------------------------------------------------------
    | Analytics and Tracking
    |--------------------------------------------------------------------------
    */

    'analytics' => [
        'enabled' => true,
        'track_views' => true,
        'track_clicks' => true,
        'track_geographic' => true,
        'track_user_agent' => true,
        'track_referrer' => true,
        'anonymize_ip' => true,
        'retention_days' => 365,
        'real_time_updates' => true,
        'export_formats' => ['csv', 'json', 'pdf'],
    ],

    /*
    |--------------------------------------------------------------------------
    | Performance Settings
    |--------------------------------------------------------------------------
    */

    'performance' => [
        'cache_duration' => 3600, // seconds
        'cdn_enabled' => env('TRUSTSEAL_CDN_ENABLED', false),
        'cdn_url' => env('TRUSTSEAL_CDN_URL'),
        'minify_css' => env('TRUSTSEAL_MINIFY_CSS', true),
        'minify_js' => env('TRUSTSEAL_MINIFY_JS', true),
        'lazy_loading' => true,
        'preload_fonts' => true,
    ],

    /*
    |--------------------------------------------------------------------------
    | Customization Limits
    |--------------------------------------------------------------------------
    */

    'limits' => [
        'free_plan' => [
            'max_domains' => 1,
            'max_seals_per_domain' => 1,
            'available_types' => ['badge'],
            'available_themes' => ['light', 'dark'],
            'custom_css' => false,
            'analytics_retention_days' => 30,
        ],
        'basic_plan' => [
            'max_domains' => 5,
            'max_seals_per_domain' => 3,
            'available_types' => ['badge', 'banner'],
            'available_themes' => ['light', 'dark'],
            'custom_css' => false,
            'analytics_retention_days' => 90,
        ],
        'premium_plan' => [
            'max_domains' => 25,
            'max_seals_per_domain' => 10,
            'available_types' => ['badge', 'banner', 'widget', 'floating'],
            'available_themes' => ['light', 'dark', 'brand'],
            'custom_css' => true,
            'analytics_retention_days' => 365,
        ],
        'enterprise_plan' => [
            'max_domains' => -1, // unlimited
            'max_seals_per_domain' => -1, // unlimited
            'available_types' => ['badge', 'banner', 'widget', 'floating', 'modal'],
            'available_themes' => ['light', 'dark', 'brand'],
            'custom_css' => true,
            'white_label' => true,
            'analytics_retention_days' => -1, // unlimited
        ],
    ],

    /*
    |--------------------------------------------------------------------------
    | API Settings
    |--------------------------------------------------------------------------
    */

    'api' => [
        'rate_limits' => [
            'display' => 1000, // requests per minute
            'config' => 60, // requests per minute
            'analytics' => 100, // requests per minute
        ],
        'cors' => [
            'allowed_origins' => ['*'],
            'allowed_methods' => ['GET', 'POST', 'OPTIONS'],
            'allowed_headers' => ['Content-Type', 'Authorization'],
        ],
        'cache_headers' => [
            'public' => true,
            'max_age' => 3600,
            'etag' => true,
        ],
    ],

    /*
    |--------------------------------------------------------------------------
    | Notification Settings
    |--------------------------------------------------------------------------
    */

    'notifications' => [
        'domain_verified' => [
            'enabled' => true,
            'channels' => ['mail', 'database'],
        ],
        'security_alert' => [
            'enabled' => true,
            'channels' => ['mail', 'database', 'broadcast'],
            'threshold' => 'warning', // info, warning, error, critical
        ],
        'ssl_expiry' => [
            'enabled' => true,
            'channels' => ['mail', 'database'],
            'warning_days' => [30, 14, 7, 1],
        ],
        'malware_detected' => [
            'enabled' => true,
            'channels' => ['mail', 'database', 'broadcast', 'sms'],
            'immediate' => true,
        ],
    ],

];