<?php

namespace Database\Seeders;

use Illuminate\Database\Seeder;
use Illuminate\Support\Facades\Hash;
use Illuminate\Support\Facades\File;
use Carbon\Carbon;

class DatabaseSeeder extends Seeder
{
    /**
     * Seed the application's database.
     */
    public function run(): void
    {
        // Create demo data as JSON files since database connection is not available
        $this->createDemoDataFiles();
        
        echo "Demo data files created successfully!\n";
        echo "\nAdmin Login Details:\n";
        echo "Email: admin@sitesafe.in\n";
        echo "Password: admin123\n";
        echo "\nDemo User Login Details:\n";
        echo "Email: demo@example.com\n";
        echo "Password: demo123\n";
    }
    
    private function createDemoDataFiles()
    {
        $storageDir = storage_path('app/demo-data');
        if (!File::exists($storageDir)) {
            File::makeDirectory($storageDir, 0755, true);
        }
        
        // Admin user
        $admin = [
            'id' => 1,
            'name' => 'Admin User',
            'email' => 'admin@sitesafe.in',
            'password' => Hash::make('admin123'),
            'email_verified_at' => now(),
            'is_premium' => true,
            'premium_expires_at' => now()->addYear(),
            'role' => 'admin',
            'created_at' => now(),
            'updated_at' => now()
        ];
        
        // Demo users
        $users = [
            $admin,
            [
                'id' => 2,
                'name' => 'Demo User',
                'email' => 'demo@example.com',
                'password' => Hash::make('demo123'),
                'email_verified_at' => now(),
                'is_premium' => false,
                'premium_expires_at' => null,
                'role' => 'user',
                'created_at' => now(),
                'updated_at' => now()
            ],
            [
                'id' => 3,
                'name' => 'John Business',
                'email' => 'john@business.com',
                'password' => Hash::make('password123'),
                'email_verified_at' => now(),
                'is_premium' => true,
                'premium_expires_at' => now()->addMonths(6),
                'role' => 'user',
                'created_at' => now()->subDays(30),
                'updated_at' => now()
            ]
        ];
        
        // Demo domains
        $domains = [
            [
                'id' => 1,
                'user_id' => 2,
                'domain_name' => 'demo-site.com',
                'verification_status' => 'verified',
                'security_score' => 85,
                'last_scan' => now()->subHours(6),
                'ssl_status' => 'valid',
                'ssl_expires_at' => now()->addMonths(3),
                'created_at' => now()->subDays(15),
                'updated_at' => now()
            ],
            [
                'id' => 2,
                'user_id' => 3,
                'domain_name' => 'business-example.com',
                'verification_status' => 'verified',
                'security_score' => 92,
                'last_scan' => now()->subHours(2),
                'ssl_status' => 'valid',
                'ssl_expires_at' => now()->addMonths(6),
                'created_at' => now()->subDays(45),
                'updated_at' => now()
            ]
        ];
        
        // Demo trust seals
        $trustSeals = [
            [
                'id' => 1,
                'domain_id' => 1,
                'seal_code' => 'TS-' . strtoupper(substr(md5('demo-site.com'), 0, 8)),
                'is_active' => true,
                'views_count' => 1250,
                'clicks_count' => 89,
                'position' => 'bottom-right',
                'style' => 'modern',
                'created_at' => now()->subDays(15),
                'updated_at' => now()
            ],
            [
                'id' => 2,
                'domain_id' => 2,
                'seal_code' => 'TS-' . strtoupper(substr(md5('business-example.com'), 0, 8)),
                'is_active' => true,
                'views_count' => 3420,
                'clicks_count' => 267,
                'position' => 'bottom-left',
                'style' => 'classic',
                'created_at' => now()->subDays(45),
                'updated_at' => now()
            ]
        ];
        
        // Save data to JSON files
        File::put($storageDir . '/users.json', json_encode($users, JSON_PRETTY_PRINT));
        File::put($storageDir . '/domains.json', json_encode($domains, JSON_PRETTY_PRINT));
        File::put($storageDir . '/trust_seals.json', json_encode($trustSeals, JSON_PRETTY_PRINT));
        
        // Create admin credentials file
        $credentials = [
            'admin' => [
                'email' => 'admin@sitesafe.in',
                'password' => 'admin123',
                'role' => 'admin'
            ],
            'demo_user' => [
                'email' => 'demo@example.com',
                'password' => 'demo123',
                'role' => 'user'
            ]
        ];
        
        File::put($storageDir . '/credentials.json', json_encode($credentials, JSON_PRETTY_PRINT));
    }
}
