@extends('layouts.app')

@section('title', 'Admin Panel - Trust Seal Portal')

@section('content')
<div class="container-fluid">
    <!-- Admin Header -->
    <div class="row mb-4">
        <div class="col-12">
            <div class="card border-0 bg-gradient-danger text-white">
                <div class="card-body py-4">
                    <div class="row align-items-center">
                        <div class="col">
                            <h1 class="h3 mb-1">Admin Panel</h1>
                            <p class="mb-0 opacity-75">System Administration & Management</p>
                        </div>
                        <div class="col-auto">
                            <div class="icon icon-shape bg-white text-danger rounded-circle">
                                <svg class="h-6 w-6" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                                    <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M12 6V4m0 2a2 2 0 100 4m0-4a2 2 0 110 4m-6 8a2 2 0 100-4m0 4a2 2 0 100 4m0-4v2m0-6V4m6 6v10m6-2a2 2 0 100-4m0 4a2 2 0 100 4m0-4v2m0-6V4"></path>
                                </svg>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>

    <!-- System Statistics -->
    <div class="row mb-4">
        <div class="col-xl-3 col-md-6 mb-4">
            <div class="card border-left-primary shadow h-100 py-2">
                <div class="card-body">
                    <div class="row no-gutters align-items-center">
                        <div class="col mr-2">
                            <div class="text-xs font-weight-bold text-primary text-uppercase mb-1">
                                Total Users
                            </div>
                            <div class="h5 mb-0 font-weight-bold text-gray-800">{{ count($users) }}</div>
                        </div>
                        <div class="col-auto">
                            <i class="fas fa-users fa-2x text-gray-300"></i>
                        </div>
                    </div>
                </div>
            </div>
        </div>

        <div class="col-xl-3 col-md-6 mb-4">
            <div class="card border-left-success shadow h-100 py-2">
                <div class="card-body">
                    <div class="row no-gutters align-items-center">
                        <div class="col mr-2">
                            <div class="text-xs font-weight-bold text-success text-uppercase mb-1">
                                Total Domains
                            </div>
                            <div class="h5 mb-0 font-weight-bold text-gray-800">{{ count($domains) }}</div>
                        </div>
                        <div class="col-auto">
                            <i class="fas fa-globe fa-2x text-gray-300"></i>
                        </div>
                    </div>
                </div>
            </div>
        </div>

        <div class="col-xl-3 col-md-6 mb-4">
            <div class="card border-left-info shadow h-100 py-2">
                <div class="card-body">
                    <div class="row no-gutters align-items-center">
                        <div class="col mr-2">
                            <div class="text-xs font-weight-bold text-info text-uppercase mb-1">
                                Active Seals
                            </div>
                            <div class="h5 mb-0 font-weight-bold text-gray-800">{{ count($trustSeals) }}</div>
                        </div>
                        <div class="col-auto">
                            <i class="fas fa-shield-alt fa-2x text-gray-300"></i>
                        </div>
                    </div>
                </div>
            </div>
        </div>

        <div class="col-xl-3 col-md-6 mb-4">
            <div class="card border-left-warning shadow h-100 py-2">
                <div class="card-body">
                    <div class="row no-gutters align-items-center">
                        <div class="col mr-2">
                            <div class="text-xs font-weight-bold text-warning text-uppercase mb-1">
                                System Status
                            </div>
                            <div class="h5 mb-0 font-weight-bold text-gray-800">
                                <span class="badge badge-success">Online</span>
                            </div>
                        </div>
                        <div class="col-auto">
                            <i class="fas fa-server fa-2x text-gray-300"></i>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>

    <!-- Management Tabs -->
    <div class="row">
        <div class="col-12">
            <div class="card shadow">
                <div class="card-header">
                    <ul class="nav nav-tabs card-header-tabs" id="adminTabs" role="tablist">
                        <li class="nav-item" role="presentation">
                            <a class="nav-link active" id="users-tab" data-toggle="tab" href="#users" role="tab" aria-controls="users" aria-selected="true">
                                <i class="fas fa-users mr-2"></i>Users
                            </a>
                        </li>
                        <li class="nav-item" role="presentation">
                            <a class="nav-link" id="domains-tab" data-toggle="tab" href="#domains" role="tab" aria-controls="domains" aria-selected="false">
                                <i class="fas fa-globe mr-2"></i>Domains
                            </a>
                        </li>
                        <li class="nav-item" role="presentation">
                            <a class="nav-link" id="seals-tab" data-toggle="tab" href="#seals" role="tab" aria-controls="seals" aria-selected="false">
                                <i class="fas fa-shield-alt mr-2"></i>Trust Seals
                            </a>
                        </li>
                        <li class="nav-item" role="presentation">
                            <a class="nav-link" id="analytics-tab" data-toggle="tab" href="#analytics" role="tab" aria-controls="analytics" aria-selected="false">
                                <i class="fas fa-chart-bar mr-2"></i>Analytics
                            </a>
                        </li>
                    </ul>
                </div>
                <div class="card-body">
                    <div class="tab-content" id="adminTabsContent">
                        <!-- Users Tab -->
                        <div class="tab-pane fade show active" id="users" role="tabpanel" aria-labelledby="users-tab">
                            <div class="table-responsive">
                                <table class="table table-hover">
                                    <thead>
                                        <tr>
                                            <th>ID</th>
                                            <th>Name</th>
                                            <th>Email</th>
                                            <th>Role</th>
                                            <th>Status</th>
                                            <th>Created</th>
                                            <th>Actions</th>
                                        </tr>
                                    </thead>
                                    <tbody>
                                        @foreach($users as $user)
                                        <tr>
                                            <td>{{ $user['id'] }}</td>
                                            <td>
                                                <div class="d-flex align-items-center">
                                                    <div class="avatar avatar-sm rounded-circle mr-2 bg-primary text-white d-flex align-items-center justify-content-center">
                                                        {{ substr($user['name'], 0, 1) }}
                                                    </div>
                                                    <div>
                                                        <h6 class="mb-0 text-sm">{{ $user['name'] }}</h6>
                                                    </div>
                                                </div>
                                            </td>
                                            <td>{{ $user['email'] }}</td>
                                            <td>
                                                @if($user['role'] === 'admin')
                                                    <span class="badge badge-danger">Admin</span>
                                                @else
                                                    <span class="badge badge-secondary">User</span>
                                                @endif
                                            </td>
                                            <td>
                                                @if($user['email_verified_at'])
                                                    <span class="badge badge-success">Verified</span>
                                                @else
                                                    <span class="badge badge-warning">Unverified</span>
                                                @endif
                                            </td>
                                            <td>{{ date('M j, Y', strtotime($user['created_at'])) }}</td>
                                            <td>
                                                <div class="btn-group" role="group">
                                                    <button type="button" class="btn btn-sm btn-outline-primary">View</button>
                                                    <button type="button" class="btn btn-sm btn-outline-secondary">Edit</button>
                                                </div>
                                            </td>
                                        </tr>
                                        @endforeach
                                    </tbody>
                                </table>
                            </div>
                        </div>

                        <!-- Domains Tab -->
                        <div class="tab-pane fade" id="domains" role="tabpanel" aria-labelledby="domains-tab">
                            <div class="table-responsive">
                                <table class="table table-hover">
                                    <thead>
                                        <tr>
                                            <th>ID</th>
                                            <th>Domain</th>
                                            <th>Owner</th>
                                            <th>Status</th>
                                            <th>Security Score</th>
                                            <th>Created</th>
                                            <th>Actions</th>
                                        </tr>
                                    </thead>
                                    <tbody>
                                        @foreach($domains as $domain)
                                        <tr>
                                            <td>{{ $domain['id'] }}</td>
                                            <td>
                                                <div class="d-flex align-items-center">
                                                    <i class="fas fa-globe text-primary mr-2"></i>
                                                    <div>
                                                        <h6 class="mb-0 text-sm">{{ $domain['domain_name'] }}</h6>
                                                    </div>
                                                </div>
                                            </td>
                                            <td>
                                                @php
                                                    $owner = collect($users)->firstWhere('id', $domain['user_id']);
                                                @endphp
                                                {{ $owner['name'] ?? 'Unknown' }}
                                            </td>
                                            <td>
                                                @if($domain['is_verified'])
                                                    <span class="badge badge-success">Verified</span>
                                                @else
                                                    <span class="badge badge-warning">Pending</span>
                                                @endif
                                            </td>
                                            <td>
                                                <div class="d-flex align-items-center">
                                                    <span class="mr-2">{{ $domain['security_score'] ?? 0 }}%</span>
                                                    <div class="progress" style="width: 60px; height: 6px;">
                                                        <div class="progress-bar bg-success" role="progressbar" 
                                                             style="width: {{ $domain['security_score'] ?? 0 }}%" 
                                                             aria-valuenow="{{ $domain['security_score'] ?? 0 }}" 
                                                             aria-valuemin="0" aria-valuemax="100"></div>
                                                    </div>
                                                </div>
                                            </td>
                                            <td>{{ date('M j, Y', strtotime($domain['created_at'])) }}</td>
                                            <td>
                                                <div class="btn-group" role="group">
                                                    <button type="button" class="btn btn-sm btn-outline-primary">View</button>
                                                    <button type="button" class="btn btn-sm btn-outline-secondary">Edit</button>
                                                </div>
                                            </td>
                                        </tr>
                                        @endforeach
                                    </tbody>
                                </table>
                            </div>
                        </div>

                        <!-- Trust Seals Tab -->
                        <div class="tab-pane fade" id="seals" role="tabpanel" aria-labelledby="seals-tab">
                            <div class="table-responsive">
                                <table class="table table-hover">
                                    <thead>
                                        <tr>
                                            <th>ID</th>
                                            <th>Seal Code</th>
                                            <th>Domain</th>
                                            <th>Status</th>
                                            <th>Views</th>
                                            <th>Created</th>
                                            <th>Actions</th>
                                        </tr>
                                    </thead>
                                    <tbody>
                                        @foreach($trustSeals as $seal)
                                        <tr>
                                            <td>{{ $seal['id'] }}</td>
                                            <td>
                                                <code class="small">{{ $seal['seal_code'] }}</code>
                                            </td>
                                            <td>
                                                @php
                                                    $domain = collect($domains)->firstWhere('id', $seal['domain_id']);
                                                @endphp
                                                {{ $domain['domain_name'] ?? 'Unknown' }}
                                            </td>
                                            <td>
                                                @if($seal['is_active'])
                                                    <span class="badge badge-success">Active</span>
                                                @else
                                                    <span class="badge badge-secondary">Inactive</span>
                                                @endif
                                            </td>
                                            <td>{{ number_format($seal['view_count'] ?? 0) }}</td>
                                            <td>{{ date('M j, Y', strtotime($seal['created_at'])) }}</td>
                                            <td>
                                                <div class="btn-group" role="group">
                                                    <button type="button" class="btn btn-sm btn-outline-primary">View</button>
                                                    <button type="button"