@extends('layouts.app')

@section('title', 'Trust Seal Portal - Secure Your Website')

@section('content')
<div class="hero-section bg-primary text-white py-5">
    <div class="container">
        <div class="row align-items-center">
            <div class="col-lg-6">
                <h1 class="display-4 fw-bold mb-4">Secure Your Website with Trust Seals</h1>
                <p class="lead mb-4">Build customer confidence with verified security certificates and trust badges that showcase your website's reliability.</p>
                <div class="d-flex gap-3">
                    <a href="{{ route('register') }}" class="btn btn-light btn-lg px-4">Get Started</a>
                    <a href="{{ route('features') }}" class="btn btn-outline-light btn-lg px-4">Learn More</a>
                </div>
            </div>
            <div class="col-lg-6">
                <div class="text-center">
                    <i class="fas fa-shield-alt" style="font-size: 12rem; opacity: 0.8;"></i>
                </div>
            </div>
        </div>
    </div>
</div>

<div class="stats-section py-5 bg-light">
    <div class="container">
        <div class="row text-center">
            <div class="col-md-3 mb-4">
                <div class="stat-item">
                    <h3 class="display-6 fw-bold text-primary">{{ number_format($stats['verified_domains']) }}</h3>
                    <p class="text-muted">Verified Domains</p>
                </div>
            </div>
            <div class="col-md-3 mb-4">
                <div class="stat-item">
                    <h3 class="display-6 fw-bold text-primary">{{ number_format($stats['active_seals']) }}</h3>
                    <p class="text-muted">Active Trust Seals</p>
                </div>
            </div>
            <div class="col-md-3 mb-4">
                <div class="stat-item">
                    <h3 class="display-6 fw-bold text-primary">{{ number_format($stats['total_users']) }}</h3>
                    <p class="text-muted">Trusted Users</p>
                </div>
            </div>
            <div class="col-md-3 mb-4">
                <div class="stat-item">
                    <h3 class="display-6 fw-bold text-primary">{{ number_format($stats['seal_views']) }}</h3>
                    <p class="text-muted">Seal Views</p>
                </div>
            </div>
        </div>
    </div>
</div>

<div class="features-section py-5">
    <div class="container">
        <div class="row">
            <div class="col-lg-8 mx-auto text-center mb-5">
                <h2 class="display-5 fw-bold mb-4">Why Choose Our Trust Seals?</h2>
                <p class="lead text-muted">Comprehensive security verification and trust building solutions for modern websites.</p>
            </div>
        </div>
        <div class="row">
            <div class="col-md-4 mb-4">
                <div class="feature-card h-100 p-4 border rounded-3">
                    <div class="feature-icon mb-3">
                        <i class="fas fa-check-circle text-success" style="font-size: 2.5rem;"></i>
                    </div>
                    <h4 class="fw-bold mb-3">Domain Verification</h4>
                    <p class="text-muted">Verify domain ownership through multiple methods including DNS, file upload, and meta tags.</p>
                </div>
            </div>
            <div class="col-md-4 mb-4">
                <div class="feature-card h-100 p-4 border rounded-3">
                    <div class="feature-icon mb-3">
                        <i class="fas fa-lock text-primary" style="font-size: 2.5rem;"></i>
                    </div>
                    <h4 class="fw-bold mb-3">SSL Security</h4>
                    <p class="text-muted">Comprehensive SSL certificate monitoring and security scanning for your website.</p>
                </div>
            </div>
            <div class="col-md-4 mb-4">
                <div class="feature-card h-100 p-4 border rounded-3">
                    <div class="feature-icon mb-3">
                        <i class="fas fa-chart-line text-info" style="font-size: 2.5rem;"></i>
                    </div>
                    <h4 class="fw-bold mb-3">Analytics & Insights</h4>
                    <p class="text-muted">Track seal performance and visitor trust metrics with detailed analytics.</p>
                </div>
            </div>
        </div>
    </div>
</div>

<div class="testimonials-section py-5 bg-light">
    <div class="container">
        <div class="row">
            <div class="col-lg-8 mx-auto text-center mb-5">
                <h2 class="display-5 fw-bold mb-4">What Our Customers Say</h2>
            </div>
        </div>
        <div class="row">
            @foreach($testimonials as $testimonial)
            <div class="col-md-4 mb-4">
                <div class="testimonial-card h-100 p-4 bg-white border rounded-3 shadow-sm">
                    <div class="stars mb-3">
                        @for($i = 1; $i <= 5; $i++)
                            <i class="fas fa-star {{ $i <= $testimonial['rating'] ? 'text-warning' : 'text-muted' }}"></i>
                        @endfor
                    </div>
                    <p class="mb-3">"{{ $testimonial['message'] }}"</p>
                    <div class="testimonial-author">
                        <strong>{{ $testimonial['name'] }}</strong><br>
                        <small class="text-muted">{{ $testimonial['company'] }}</small>
                    </div>
                </div>
            </div>
            @endforeach
        </div>
    </div>
</div>

<div class="cta-section py-5 bg-primary text-white">
    <div class="container">
        <div class="row">
            <div class="col-lg-8 mx-auto text-center">
                <h2 class="display-5 fw-bold mb-4">Ready to Build Trust?</h2>
                <p class="lead mb-4">Join thousands of websites that have increased their conversion rates with our trust seals.</p>
                <a href="{{ route('register') }}" class="btn btn-light btn-lg px-5">Start Free Trial</a>
            </div>
        </div>
    </div>
</div>
@endsection

@push('styles')
<style>
.hero-section {
    background: linear-gradient(135deg, #667eea 0%, #764ba2 100%);
}

.feature-card {
    transition: transform 0.3s ease, box-shadow 0.3s ease;
}

.feature-card:hover {
    transform: translateY(-5px);
    box-shadow: 0 10px 25px rgba(0,0,0,0.1);
}

.testimonial-card {
    transition: transform 0.3s ease;
}

.testimonial-card:hover {
    transform: translateY(-3px);
}

.stat-item h3 {
    font-size: 3rem;
}
</style>
@endpush